// Rim Shader test
// see "http://www.fundza.com/rman_shaders/surface/fake_rim/fake_rim1.html" for a good explanation of rim shading
// 2006 Michael Mandel

uniform vec3  baseColor;

uniform vec3 rimColor;
uniform float rimSpread;    
uniform float rimIntensity;  

varying vec3  Normal;
varying vec3  EyeDir;
varying float LightIntensity;

void main (void)
{
    //base diffuse lighting
    vec3 base = LightIntensity * baseColor;

    vec3 Color = base;	


    //compute rim contribution
    float rimBase = 1.0 - max(dot(Normal, normalize(-EyeDir)), 0.0); 
    float rim = smoothstep(1.0 - rimSpread, 1.0, rimBase)* rimIntensity;

    //smaller powers spread more, so we reverse and scale the spead param
    //float rimPower = (1.0 - rimSpread)*10.0;
    //25 seems like a nice max for the intensity
    //float rimIntensityScale = rimIntensity*25.0;
    //float rim = pow(rimBase * rimIntensityScale, rimPower);

    //add in rim lighting
    Color += (rimColor * rim).xyz;

    gl_FragColor = vec4 (Color, 1.0);
}